#ifndef __SAVE_STATES____H__
#define __SAVE_STATES____H__

#include <SDL.h>

// size in bytes of zxian's custom save-state files
#define STATE_SIZE	(0xC021)

void savestates_keyup(SDL_Keysym key);
void savestates_handle_load();
void savestates_handle_save();

void savestates_start(char* path);
void savestates_destroy();

// loads and activates a save state from a save state buffer
// buffer must be of size STATE_SIZE
void savestates_load_from_buffer(Uint8* buffer);
// saves a state to a buffer
// buffer must be of size STATE_SIZE
void savestates_save_to_buffer(Uint8* buffer);

#endif  // !__SAVE_STATES____H__