#ifndef __NOTIFICATION____H__
#define __NOTIFICATION____H__

#include <SDL.h>

typedef void func_on_notification_disappear_callback();

/// <summary>
/// RETURNS:
///     0 when notification shouldn't be cancelled, other value otherwise
/// </summary>
typedef Uint8 func_notification_must_cancel_callback();

/// <param name="message"></param>
/// <param name="durationMs"></param>
/// <param name="onDisappearCallback">Can be NULL</param>
/// <param name="mustCancelCallback">Can be NULL</param>
void notification_show(
	char* message,
	Uint32 durationMs,
	func_on_notification_disappear_callback* onDisappearCallback,
	func_notification_must_cancel_callback* mustCancelCallback
);

Uint8 notification_render(SDL_Renderer* renderer);

void notification_start(Uint16 width, Uint16 top, Uint16 left, Uint8 zoom);
void notification_destroy();

#endif  // !__NOTIFICATION____H__