#ifndef __MEMORY____H__
#define __MEMORY____H__

#include <SDL.h>

// called after the memory update occurs
typedef void func_on_memory_write_callback(Uint16 address);

void memory_start(func_on_memory_write_callback onMemoryWriteCallback);
void memory_destroy();

void memory_load(Uint8* source, Uint16 offset, Uint16 size);
void memory_dump(Uint8* destination, Uint16 startAddress, Uint16 size);

Uint8 memory_read8(Uint16 address);
Uint16 memory_read16(Uint16 address);
// like read, but intended for throw-away reads, which will take place again
Uint8 memory_peek8(Uint16 address);

void memory_write8(Uint16 address, Uint8 value);
void memory_write16(Uint16 address, Uint16 value);

void memory_enter_access_counting_context(Uint16 startAddressInclusive, Uint16 size);
Uint32 memory_peek_access_counting_context();
void memory_leave_access_counting_context();

int memory_compute_hash(Uint16 startAddress, Uint16 size);

#endif  // !__MEMORY____H__