#ifndef __IO____H__
#define __IO____H__

#include <SDL.h>
#include <SDL_timer.h>

void io_start();
void io_destroy();

Uint8 io_read8_16bitaddr(Uint16 port);
void io_write8_16bitaddr(Uint16 port, Uint8 value);

/// <summary>
/// Captures next executed instruction's port access
/// Even string operations (e.g. OTIR) are seen are a sequence of single instructions,
///     each with its own capture context
/// </summary>
void io_enter_access_capture_context();

/// <param name="address">OUTPUT argument: the IO port address accessed within the context, when an access was made</param>
/// <returns>0 when no IO port access was made within the capture context; other value otherwise</returns>
Uint8 io_peek_access_capture_context(Uint16* address);

void io_leave_access_capture_context();

Uint8 io_read8_border_colour();
void io_set8_border_colour_uncontended(Uint8 value);

/// <returns>1 when active, 0 when not</returns>
Uint8 io_is_speaker_active();

void io_ear_write1_uncontended(Uint8 value);

#endif  // !__IO____H__
