#ifndef __CONTENTION____H__
#define __CONTENTION____H__

#include "Contention.h"
#include "Cpu.h"

// this module implements the logic to emulate the memory/IO contention which
// can occur by design on the ZX Spectrum
//
// the result of such contention modifies the timing of the CPU, which may be
// suspended temporarily when accessing contended memory/IO while another part
// of the ZX Spectrum system (i.e. the ULA) requires exclusive access

// these callbacks are given to CPU routines to invoke as it executes instructions
void contention_before_cpu_instruction_executed(Uint64 tstatesElapsedInScanline);
/// <returns>Amount of delay tstates</returns>
Uint32 contention_finalize_instruction(const struct instruction* instruction);
/// <returns>Amount of delay tstates</returns>
Uint32 contention_get_contention_for_inflight_instruction(const struct instruction* instruction);

void contention_start();
void contention_destroy();

#endif