#include <SDL.h>
#include <stdio.h>
#include <string.h>

#include "ConfigFileReader.h"
#include "TextFileReader.h"
#include "Log.h"

// callback
void _config_file_reader__on_line_read(char* line, void* extraParams) {
	if (line == NULL || line[0] == 0) {
		// empty line
		return;
	}

	if (line[0] == '#') {
		// comment line
		return;
	}

	// extract config property name and value

	func_config_file_reader_on_property_read onPropertyReadCallback = (func_config_file_reader_on_property_read)extraParams;
	if (onPropertyReadCallback == NULL) {
		return;
	}

	char* pointerToEqualsSign = strchr(line, '=');
	if (pointerToEqualsSign == NULL) {
		// equals sign not found
		return;
	}

	// "property value" starts immediately after equals sign
	//     edge case: it'll point to a terminator, making it an empty string
	char* propertyValue = pointerToEqualsSign + 1;

	// temporarily replace equal sign with a terminator, to terminate "property name"
	(*pointerToEqualsSign) = 0;

	onPropertyReadCallback(line, propertyValue);

	// restore equals sign
	(*pointerToEqualsSign) = '=';
}

void config_file_reader__read_config_properties(char* fileName, func_config_file_reader_on_property_read onPropertyReadCallback)
{
	text_file_reader__read_lines(fileName, _config_file_reader__on_line_read, (void*)onPropertyReadCallback);
}
