#include "FileUtilities.h"

WCHAR** file_utilities__list_files_in_directory(WCHAR* directory, WCHAR* fileMask, int* numFilesOUT)
{
    WIN32_FIND_DATA findFileData;
    HANDLE hFind = NULL;

    *numFilesOUT = 0;

#define MAX_FULL_PATH 2048
    WCHAR* fullPath = (WCHAR*)malloc((MAX_FULL_PATH + 1) * sizeof(WCHAR));
    if (fullPath == NULL) {
        return NULL;
    }

    // file mask
    swprintf(fullPath, MAX_FULL_PATH, L"%s\\%s", directory, fileMask);

    if ((hFind = FindFirstFileW(fullPath, &findFileData)) == INVALID_HANDLE_VALUE)
    {
        // directory is inaccessible, so we're done
        free(fullPath);
        return NULL;
    }

#define MAX_RESULTS 1024
    WCHAR** result = (WCHAR**)malloc(MAX_RESULTS * sizeof(WCHAR*));
    if (result == NULL) {
        free(fullPath);
        return NULL;
    }

    do
    {
        // exclude directories
        if (!wcscmp(findFileData.cFileName, L".") || !wcscmp(findFileData.cFileName, L".."))
        {
            continue;
        }

        // build full path from passed-in directory and file name
        swprintf(fullPath, MAX_FULL_PATH, L"%s\\%s", directory, findFileData.cFileName);

        if (!(findFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
        {
            // it's a file (as opposed to a directory)

            // store it in the result
            result[*numFilesOUT] = (WCHAR*)malloc((MAX_FULL_PATH + 1) * sizeof(WCHAR));
            if (result[*numFilesOUT] == NULL) {
                // as soon as we fail one allocation, we're done
                break;
            }

            // copy full path into result
            swprintf(result[*numFilesOUT], MAX_FULL_PATH, L"%s", fullPath);

            // we've successfully accumulated the file
            (*numFilesOUT)++;
        }
    } while (FindNextFile(hFind, &findFileData) && ((*numFilesOUT) < MAX_RESULTS));

    FindClose(hFind);
    free(fullPath);
    return result;
}