#ifndef __VIDEO____H__
#define __VIDEO____H__

#include <SDL.h>

// initialization order:
//
// video_set_renderer_type()    [OPTIONAL]
// video_set_display_mode()     [MANDATORY]
// video_start()                [MANDATORY]

enum videoMode {
    Video_viaQueueTimer = 0,
    Video_viaSDLTimer = 1
};

enum videoDisplayMode {
    Video_DisplayMode_Windowed = 0,
    Video_DisplayMode_DesktopFullscreen = 1,
    Video_DisplayMode_Fullscreen = 2
};

void video_set_renderer_type(Uint8 renderer);

// the absolute "zeroes"
// since in fullscreen we center the ZX Spectrum screen, these vary with the resolution of 
// the video card display mode
void video_get_display_coordinates(int* left, int* top);

Uint8 video_start(enum videoMode videoMode, SDL_Window* window, char zoom, int windowWidth, int windowHeight, enum videoDisplayMode videoDisplayMode);
void video_destroy();

void video_disable_frameskip();
void video_enable_scanline_effect(Uint8 amount);

// percentage of frame target duration before frameskip starts
void video_set_lag_allowance_before_frameskip(Uint8 percent);

SDL_Renderer* video_get_renderer();

void video_force_next_frame_full_render();
void video_handle_memory_write(Uint16 address);

#endif // !__VIDEO____H__
