#ifndef __CPU_UTILS____H__
#define __CPU_UTILS____H__

#include <SDL.h>

void cpu_increment_R();

void cpu_set_instruction_disassembled_name(struct instruction* instruction, char* source);

void cpu_set_instruction_disassembled_name_formatted_str(struct instruction* instruction, const char* source, Uint16 number0, Uint16 number1, const char* string0, const char* string1);
void cpu_set_instruction_disassembled_name_formatted2(struct instruction* instruction, const char* source, Uint16 number0, Uint16 number1);

void cpu_mark_instruction_unknown(struct instruction* instruction);
void cpu_mark_instruction_executed(struct instruction* instruction);
void cpu_finalize_instruction_decode(struct instruction* instruction, Uint16 additionalTStates);
Uint8 cpu_must_execute();

void cpu_read_imm16(struct instruction* instruction);
void cpu_read_imm8(struct instruction* instruction);

void cpu_save_flags();
void cpu_restore_flags(Uint8 positions);

Uint8 cpu_parity(Uint8 val);

const char* cpu_make_regs_dump_string__static_mem_ptr();
void cpu_print_regs();

void cpu_swap16(Uint16* first, Uint16* second);
Uint16 cpu_pop16();
void cpu_push16(Uint16 val16);
void cpu_push_PC();


cpu_addc_binary8(Uint8* value, Uint8 increment, Uint8 carry);
cpu_addc_binary16(Uint16* value, Uint16 increment, Uint16 carry);
cpu_subc_binary8(Uint8* value, Uint8 increment, Uint8 carry);
cpu_subc_binary16(Uint16* value, Uint16 increment, Uint16 carry);

Uint16 cpu_neg8(Uint8 val8);
void cpu_set_instruction_disassembled_name_formatted_indexreg16_plus_imm8(
	struct instruction* instruction, const char* sourceNonNegative, const char* sourceNegative, const char* indexRegName);
Uint16 cpu_compute_absolute_address(Uint16 reg16, Uint8 offset);

Uint16* cpu_get_indexreg16_ptr(struct instruction* instruction);
Uint8* cpu_get_indexreg8h_ptr(struct instruction* instruction);
Uint8* cpu_get_indexreg8l_ptr(struct instruction* instruction);
const char* cpu_get_indexreg16_name(struct instruction* instruction);
const char* cpu_get_indexreg8h_name(struct instruction* instruction);
const char* cpu_get_indexreg8l_name(struct instruction* instruction);

void cpu_instruction__add_reg16_reg16(struct instruction* instruction, Uint16* reg, Uint16 reg16, const char* disassembledName);
void cpu_instruction__pop_reg16(struct instruction* instruction, Uint16* reg, const char* disassembledName);
void cpu_instruction__push_reg16(struct instruction* instruction, Uint16 val16, const char* disassembledName);

#endif // !__CPU_UTILS____H__
